<?php

$limit = Field::exists('limit') ? Field::get('limit') : 5;
$compare = Field::exists('show_only_past_events') ? '<' : '>=';
$order = Field::exists('show_only_past_events') ? 'DESC' : 'ASC';

//event_date_time

$args = array(
    'post_type' => 'tc_events',
    'numberposts' => $limit,
    'tax_query' => array (
        array (
            'taxonomy' => 'event_category',
            'field' => 'term_id',
            'terms' => Field::get('category'),
        ),
    ),
    'meta_key'  => 'event_end_date_time',
    'meta_value' => date('Y-m-d h:i'),
    'orderby' => 'meta_value',
    'meta_compare' => $compare,
    'order' => $order,
);

$events = get_posts( $args );

?>

<div class="upcoming-events-content">
    <?php Field::html('title', '<h3>%s</h3>'); ?>

    <?php if( count($events) > 0 ) : ?>

    <div class="events">
        <?php foreach ( $events as $post ) : ?>
            <?php setup_postdata($post); ?>
            <div class="event">
                <a href="<?php the_permalink(); ?>">
                    <?php if(has_post_thumbnail()): ?>
                    <div class="image"><?php the_post_thumbnail('large'); ?></div>
                    <?php endif; ?>
                    <div class="event-details">
                        <div class="name"><?php the_title(); ?></div>
                        <div class="tc_event_data_widget"><?php echo display_event_date(); ?></div>
                        <div class="excerpt"><?php echo get_field('event_excerpt'); ?></div>
                    </div>
                </a>
            </div>
        <?php wp_reset_postdata(); ?>
        <?php endforeach; ?>
    </div>

    <?php else: ?>

    <p><?php _e('There are no upcoming events at this time. Check back soon!'); ?></p>

    <?php endif; ?> 
</div>
