<div class="content-with-sidebar side-right">
    <div class="container">
        <div class="content">
            <?php the_post_thumbnail('banner'); ?>
            <div class="title-block">
                <h2 class="title"><?php the_title(); ?></h2>
            </div>
            <?php if( get_post_type() == 'post' ) :
                // don't want to display if event because it uses own custom date field ?>
                <p class="date"><?php the_date(); ?></p>
            <?php endif; ?>
            <?php the_content(); ?>
        </div>
        <aside class="sidebar">

            <div class="title-block">
                <h3 class="title"><?php _e('More Behind The Scenes', DOMAIN); ?></h3>
            </div>
            <?php

            $articles = new WP_Query([
                'posts_per_page' => 8,
                'post__not_in' => array(get_the_ID()),
            ]);

            if ($articles->have_posts()) :
                echo '<ul class="related-posts">';

                while ($articles->have_posts()) : $articles->the_post();
                    echo '<li><a href="' . get_the_permalink() . '">' . get_the_post_thumbnail(get_the_ID() ,'thumbnail') . '<span class="related-text">' . get_the_title() . '<span class="related-date">' . get_the_date() . '</span></span></a></li>';
                endwhile;

                echo '</ul>';
            endif;

            ?>
        </aside>
    </div>
</div>
