<?php

$compare = Field::exists('show_only_past_events') ? '<' : '>';
$order = Field::exists('show_only_past_events') ? 'DESC' : 'ASC';

//event_date_time
$args = array(
    'post_type' => 'tc_events',
    'numberposts' => -1,
    'tax_query' => array (
        array (
            'taxonomy' => 'event_category',
            'field' => 'term_id',
            'terms' => Field::get('category'),
        ),
    ),
    'meta_key'  => 'event_end_date_time',
    'meta_value' => date('Y-m-d h:i'),
    'orderby' => 'meta_value',
    'meta_compare' => $compare,
    'order' => $order,
);

$events = get_posts( $args );

?>

<div class="<?php Layout::classes('upcoming-events'); ?>" style="<?php Layout::partial('background'); ?>"<?php Layout::id(); ?>>
    <?php Layout::partials('videobg', 'overlay'); ?>
    <div class="container">
        <?php Layout::partial('title'); ?>

        <div class="events">
            <?php foreach ( $events as $post ) : ?>
                <?php setup_postdata($post); ?>
                <div class="event">
                    <a href="<?php the_permalink(); ?>">
                        <div class="image"><?php the_post_thumbnail(); ?></div>
                        <div class="event-details">
                            <div class="name"><?php the_title(); ?></div>
                            <div class="excerpt"><?php echo get_field('event_excerpt'); ?></div>
                        </div>
                    </a>
                </div>
            <?php wp_reset_postdata(); ?>
            <?php endforeach; ?>
        </div>
    </div>
</div>