
    <footer class="footer" role="contentinfo">
        <div class="container">

            <div class="footer-top">

                <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home" class="logo">
                    <img src="<?php echo get_template_directory_uri(); ?>/img/logo_white.png" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>">
                </a>

                <nav class="nav" aria-label="site">
                    <?php wp_nav_menu([
                        'theme_location' => 'secondary',
                        'depth' => 1,
                    ]); ?>
                </nav>
            
                <div class="sponsors">
                    <?php foreach (get_field('sponsors', 'option') as $sponsor) : ?>
                        <a class="sponsor" href="<?php echo $sponsor['link']; ?>"><img src="<?php echo $sponsor['image']['sizes']['medium']; ?>"></a>
                    <?php endforeach; ?>    
                </div>

            </div>

            <div itemscope itemtype="http://schema.org/LocalBusiness" class="address">
                <p itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">
                    <?php if (get_field('address', 'option')) : ?>
                        <span itemprop="streetAddress"><?php the_field('address', 'option'); ?></span>
                    <?php endif; ?>
                    <?php if (get_field('city', 'option')) : ?>
                        <span itemprop="addressLocality"><?php the_field('city', 'option'); ?></span>,
                    <?php endif; ?>
                    <?php if (get_field('province', 'option')) : ?>
                        <span itemprop="addressRegion"><?php the_field('province', 'option'); ?></span>
                    <?php endif; ?>
                    <?php if (get_field('postal_code', 'option')) : ?>
                        <span itemprop="postalCode"><?php the_field('postal_code', 'option'); ?></span>
                    <?php endif; ?>
                </p>

                <?php if (get_field('footer_hours', 'option')) : ?>
                <div class="footer-hours">
                    <?php the_field('footer_hours', 'option'); ?>
                </div>
                <?php endif; ?>

                <?php if (get_field('phone_numbers', 'option')) : ?>
                    <div class="footer-phone">
                    <?php foreach (get_field('phone_numbers', 'option') as $phone) : ?>
                        <div class="phone-number">
                        <?php _e($phone['label'], DOMAIN); ?> <span itemprop="<?php echo $phone['type'] == 'faxNumber' ? $phone['type'] : 'telephone'; ?>"><?php echo $phone['number']; ?></span>
                        </div>
                    <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <?php if (get_field('email', 'option')) : ?>
                <div class="footer-email">
                    <?php the_field('email', 'option'); ?>
                </div>
                <?php endif; ?> 

                <div class="social">
                    <?php Layout::partial('social'); ?>
                </div>
            </div>
        </div>
    </footer>

    <div id="footer-credit" class="<?php the_field('site_credit_style', 'option'); ?>"></div>

    <?php wp_footer(); ?>

</body>
</html>
