<?php

// Development Environment (local, staging or production)
define('ENV', 'local');

// Translation string domain
define('DOMAIN', 'arcadia');

// Current directory
define('BASE', dirname(__FILE__));

// Google Maps API Key
define('GOOGLEAPI', 'AIzaSyDivzhX9fUCCqvaJWhbVXu-y1EDBCycwuU');

// Helper functions
require_once(BASE . '/inc/helpers.php');

// Autoloader
require_once(BASE . '/inc/autoloader.php');

// Load Arcadia
\Arcadia\Setup::init();

/**
 * Current Theme Setup
 */
function theme_setup()
{
    // Thumbnails
    add_theme_support('post-thumbnails');

    // Title Tag
    add_theme_support('title-tag');

    // Menus
    register_nav_menu('primary', __('Navigation Menu', DOMAIN));
    register_nav_menu('secondary', __('Footer Menu', DOMAIN));

    // When inserting an image don't link it
    update_option('image_default_link_type', 'none');

    // Remove Gallery Styling
    add_filter('use_default_gallery_style', '__return_false');

    // Additional Image Sizes
    add_image_size('banner', 1920, 1920);
    add_image_size('grid', 420, 300, true);
    add_image_size('square', 500, 500, true);
}

add_action('after_setup_theme', 'theme_setup');

/**
 * Load theme specific assets
 */
function scripts_styles()
{
    // Load Stylesheets
    wp_enqueue_style(DOMAIN . '-slick', '//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css');
    wp_enqueue_style(DOMAIN . '-slicktheme', '//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css');
    wp_enqueue_style(DOMAIN . '-style', get_stylesheet_uri());

    // Google Maps
    wp_register_script(DOMAIN . '-gmaps', 'https://maps.googleapis.com/maps/api/js?key=' . GOOGLEAPI, [], null, true);
    wp_enqueue_script(DOMAIN . '-gmaps');

    // Load JavaScript
    wp_enqueue_script(DOMAIN . '-polyfill', 'https://cdn.polyfill.io/v2/polyfill.min.js', [], null);
    wp_enqueue_script(DOMAIN . '-masonry', 'https://unpkg.com/masonry-layout@4/dist/masonry.pkgd.min.js', [], null);
    wp_enqueue_script(DOMAIN . '-masonry-imagesloaded', 'https://unpkg.com/imagesloaded@4/imagesloaded.pkgd.min.js', [], null);
    wp_enqueue_script(DOMAIN . '-slick', '//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', [], null);
    wp_enqueue_script(DOMAIN . '-main', get_template_directory_uri() . '/js/main.js', [], null, true);
}

add_action('wp_enqueue_scripts', 'scripts_styles');

/**
 * Custom Editor Styles
 * @param  array $init TinyMCE Options
 * @return array       Updated TinyMCE Options
 */
function editor_style_options($init)
{
    $style_formats = [
        [
            'title' => 'Title',
            'block' => 'h2',
            'classes' => 'title',
            'wrapper' => false,
        ],
        [
            'title' => 'Small Text (0.8em)',
            'block' => 'p',
            'classes' => 'text-small',
            'wrapper' => false,
        ],
        [
            'title' => 'Medium Text (1.2em)',
            'block' => 'p',
            'classes' => 'text-medium',
            'wrapper' => false,
        ],
        [
            'title' => 'Large Text (1.4em)',
            'block' => 'p',
            'classes' => 'text-large',
            'wrapper' => false,
        ],
        [
            'title' => 'Extra Large Text (1.6em)',
            'block' => 'p',
            'classes' => 'text-xlarge',
            'wrapper' => false,
        ],
        [
            'title' => 'Button',
            'block' => 'a',
            'classes' => 'btn',
            'wrapper' => false,
        ],
    ];

    $init['style_formats'] = json_encode($style_formats);

    return $init;
}

add_filter('tiny_mce_before_init', 'editor_style_options');

/**
 * ACF Maps Key
 */
function my_acf_init()
{
    acf_update_setting('google_api_key', GOOGLEAPI);
}

add_action('acf/init', 'my_acf_init');

function set_acf_rgba_color_picker_palette() {
    $palette = array(
        'rgba(0,119, 84, 1)',
        'rgba(148,183,96, 1)',
        'rgba(43,145,165, 1)',
        'rgba(188,230,251, 1)',
        'rgba(155,204,200, 1)',
        'rgba(255,255,0, 1)',
        'rgba(239,56,36, 1)',
        'rgba(243,125,136, 1)',
        'rgba(223,207,225, 1)',
        'rgba(0,0,0, 1)',
        'rgba(128,130,133, 1)'
    );

    return $palette;
}

add_filter('acf/rgba_color_picker/palette', 'set_acf_rgba_color_picker_palette');

remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);

/**
 * Custom function to control if we show the time based if the event is mulitple days
 */
function display_event_date() {

    $event_start_date    = get_post_meta( get_the_ID(), 'event_date_time', true );
    $event_end_date      = get_post_meta( get_the_ID(), 'event_end_date_time', true );

    $start_date  = date_i18n( get_option( 'date_format' ), strtotime( $event_start_date ) );
    $start_time  = date_i18n( get_option( 'time_format' ), strtotime( $event_start_date ) );

    $end_date    = date_i18n( get_option( 'date_format' ), strtotime( $event_end_date ) );
    $end_time    = date_i18n( get_option( 'time_format' ), strtotime( $event_end_date ) );

    $show_time = false;

    if ( !empty( $event_end_date ) ) {
        if ( $start_date == $end_date ) {
            $show_time = true;
            if ( $start_time == $end_time ) {
                $event_date = $start_date . ' ' . ($show_time ? $start_time : '');
            } else {
                $event_date = $start_date . ' ' . ($show_time ? ($start_time . ' - ' . $end_time) : '');
            }
        } else {
            if ( $start_time == $end_time ) {
                $event_date = $start_date . ' - ' . $end_date . ' ' . ($show_time ? $start_time : '');
            } else {
                $event_date = $start_date . ($show_time ? (' ' . $start_time) : '') . ' - ' . $end_date . ($show_time ? (' ' . $end_time) : '');
            }
        }
    } else {
        $event_date = $start_date . ($show_time ? (' ' . $start_time) : '');
    }

    return $event_date;

}

add_action ('wp_footer', 'colorize_tickera_categories' );
function colorize_tickera_categories() {
 
    // restrict script to page with slug 'calendar'
    if ( is_page('calendar') ) {
 
        // start building jQuery
        $op = '<script> jQuery(document).ready(function($) { ';
 
        // get all event_category term id(s)
        $terms = get_terms( array( 'taxonomy' => 'event_category', 'hide_empty' => true ) );
        // foreach
        foreach ($terms as $term){
        // get color code
            $color = get_term_meta($term->term_id, 'cc_color', true);
            // if there is a color code
            if ( $color != '' ){
                // add a line setting the classname css background value to that color code
                $op .= '$(".fc-day-grid-event.t-'.$term->term_id.'").css("background-color", "'.$color.'");';
            }
        }
 
        // close jQuery
        $op .= '});</script>';
 
        echo $op;
    }
}

function woocommerce_disable_shop_page() {
    global $post;
    if (is_shop()):
    global $wp_query;
    $wp_query->set_404();
    status_header(404);
    endif;
}
add_action( 'wp', 'woocommerce_disable_shop_page' );

add_filter('xmlrpc_enabled', '__return_false', PHP_INT_MAX);
add_filter('xmlrpc_methods', '__return_empty_array', PHP_INT_MAX);
