<!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php

    if (is_search()) {
        echo '<meta name="robots" content="noindex, nofollow">' . PHP_EOL;
    }

    ?>
    <meta name="title" content="<?php wp_title('|', true, 'right'); ?>">
    <meta name="Copyright" content="Copyright <?php bloginfo('name'); ?> <?php echo date('Y'); ?>. All Rights Reserved.">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php

    if (get_field('mobile_theme_colour', 'option')) {
        echo '<meta name="theme-color" content="' . get_field('mobile_theme_colour', 'option') . '">' . PHP_EOL;
    }

    if (get_field('ios_status_bar', 'option')) {
        echo '<meta name="apple-mobile-web-app-status-bar-style" content="' . get_field('ios_status_bar', 'option') . '">' . PHP_EOL;
    }

    ?>
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

    <?php wp_head(); ?>
    <?php Arcadia\Theme\Assets::analyticsTrackingCode(); ?>
</head>
<body <?php body_class('page-' . get_field('page_colour')); ?>>

    <a href="#main" class="skip-link"><?php _e('Skip to content', DOMAIN); ?></a>

    <header class="header" role="banner">
        <div class="container">

            <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home" class="logo">
                <img src="<?php echo get_template_directory_uri(); ?>/img/logo.png" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>">
            </a>
            <div class="inner">
                <div class="top">

                    <?php include 'searchform.php'; ?>

                    <div class="social">
                        <?php Layout::partial('social'); ?>
                    </div>

                </div>
                <div class="bottom">

                    <nav class="navigation" role="navigation" aria-label="site">
                        <?php wp_nav_menu([
                            'theme_location' => 'primary',
                            'depth' => 2,
                        ]); ?>
                    </nav>
                </div>
            </div>
        </div>
    </header>
    
    <a href="#" class="menu-trigger"><em class="fa fa-bars"></em></a>

    <div class="mobile">
        <div class="mobile-container">
            <div class="mobile-top">
                <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home" class="logo">
                    <img src="<?php echo get_template_directory_uri(); ?>/img/logo_white.png" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>">
                </a>

                <nav class="mobile-nav">    
                    <?php wp_nav_menu([
                        'theme_location' => 'primary',
                    ]); ?>
                </nav>                
            </div>

            <div class="mobile-contact">
                <p class="address">
                    <?php if (get_field('address', 'option')) : ?>
                        <span class="streetAddress"><?php the_field('address', 'option'); ?></span><br>
                    <?php endif; ?>
                    <?php if (get_field('city', 'option')) : ?>
                        <span class="addressLocality"><?php the_field('city', 'option'); ?></span>,
                    <?php endif; ?>
                    <?php if (get_field('province', 'option')) : ?>
                        <span class="addressRegion"><?php the_field('province', 'option'); ?></span>
                    <?php endif; ?>
                    <?php if (get_field('postal_code', 'option')) : ?>
                        <span class="postalCode"><?php the_field('postal_code', 'option'); ?></span>
                    <?php endif; ?>
                </p>
                <p class="phone_numbers">
                <?php if (get_field('phone_numbers', 'option')) : ?>
                    <?php foreach (get_field('phone_numbers', 'option') as $phone) : ?>
                        <div class="phone"><?php _e($phone['label'], DOMAIN); ?> <a href="tel:<?php echo preg_replace('/\D/', '', $phone['number']); ?>" itemprop="<?php echo $phone['type'] == 'faxNumber' ? $phone['type'] : 'telephone'; ?>"><?php echo $phone['number']; ?></a></div>
                    <?php endforeach; ?>
                <?php endif; ?>
                </p>
                
                <div class="social">
                    <?php Layout::partial('social'); ?>
                </div>
            </div>

        </div>
    </div>
