<?php get_header(); ?>

    <main class="main-content" role="main" id="main" tabindex="-1">

        <?php Banner::render([
            'type' => 'blog',
            'post_id' => get_option('page_for_posts'),
        ]); ?>
        
        <div class="content-with-sidebar side-right">
            <div class="container">
        
                <div class="content posts-listing">
        
                    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
        
                            <article <?php post_class() ?> id="post-<?php the_ID(); ?>">
                                <h2><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
                                <div class="posted">
                                    <?php printf(
                                        __('<time class="entry-date" datetime="%1$s" pubdate>%2$s</time>', ''),
                                        esc_attr(get_the_date('c')),
                                        esc_html(get_the_date())
                                    ); ?>
        
                                    <div class="categories"><?php the_category(', '); ?></div>
                                </div>
                                <?php the_excerpt(); ?>
                                <p class="read-more"><a class="btn" href="<?php the_permalink(); ?>"><strong><?php _e('Read Article', DOMAIN); ?></strong></a></p>
                            </article>
        
                        <?php endwhile; ?>
                    <?php else : ?>
        
                        <h2><?php _e('Blog empty', DOMAIN); ?></h2>
                        <p><?php _e('There currently aren\'t any posts published.', DOMAIN); ?></p>
        
                    <?php endif; ?>
        
                    <div class="pagination">
                        <?php echo get_previous_posts_link('Newer Articles'); ?>
                        <?php echo get_next_posts_link('Older Articles'); ?>
                    </div>
        
                </div>
                <aside class="sidebar posts-sidebar">
                    <div class="title-block">
                        <h3 class="title"><?php _e('Categories', DOMAIN); ?></h3>
                    </div>
                    <div class="links">
                    <nav aria-label="page">
                    <ul class="link-items">
                        <?php $categories = get_categories(); 
                        foreach($categories as $category) : ?>
                        
                        <li class="link-item"><a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><div class="icon"><i class="fa fa-chevron-right" aria-hidden="true"></i></div><div class="link-label"><?php echo $category->name; ?></div></a></li>
        
                        <?php endforeach; ?>
                    </ul>
                    </nav>
                    </div>
                </aside>
        
            </div>
        </div>

    </main>

<?php get_footer(); ?>
