import GoogleMap from './gmaps';
import SmoothScroll from './smoothscroll';

/**
 * Activate smooth scroll
 */
const scroll = new SmoothScroll();

/**
 * Google maps
 */
const maps = document.querySelectorAll('.acf-map');

Array.from(maps).forEach((map) => {
    const markers = map.querySelectorAll('.marker');
    const gmap = new GoogleMap(map);

    Array.from(markers).forEach((marker) => {
        gmap.addMarker(marker);
    });

    gmap.centerMap();
});

/**
 * Add anchor link tracking
 */
const links = document.querySelectorAll('a[href*="#"]');

Array.from(links).forEach((element) => {
    let href = element.getAttribute('href');

    // Clean up URL
    if (href.indexOf('#') !== false) {
        href = href.substr(href.indexOf('#'));
    }

    if (href.length > 2) {
        element.addEventListener('click', (e) => {
            // Make sure the anchor is on the current page
            if (location.pathname.replace(/^\//, '') === element.pathname.replace(/^\//, '')
                && location.hostname === element.hostname) {
                e.preventDefault();
                scroll.to(href);
            }
        });
    }
});

/**
 * Check URL for hash
 */
window.addEventListener('load', () => {
    if (window.location.hash) {
        scroll.to(window.location.hash);
    }
});

jQuery(function($) {



    // init Masonry
    var $grid = $('.upcoming-events .events').masonry({
      itemSelector: '.event',
      percentPosition: true
    });
    // layout Masonry after each image loads
    $grid.imagesLoaded().progress( function() {
      $grid.masonry();
    });  

    $('.image-slider').slick({
      infinite: true,
      speed: 500,
      slidesToShow: 1,
      variableWidth: true,
      autoplay: true,
      autoplaySpeed: 2000,
      arrows: false
    });

    var faqTab = $('.accordion .item-top'),
        faqTabContainer = $('.accordion .items');
    
    if(faqTab.length){
    
        faqTab.off('click').on('click', function(){
            var faqRow = $(this).parent(),
                faqContent = $(this).parent().find('.item-description');
            
                faqTabContainer.find('.item-description').not(faqContent).stop().slideUp('fast');
                faqTabContainer.find('.item').not(faqRow).removeClass('open');
                
                faqContent.stop().slideToggle('fast', function() {
                    faqRow.toggleClass('open', faqContent.is(':visible'));
                });
        });
        
    }

    $('.menu-trigger').click(() => {
        event.preventDefault();
        if ($('.mobile').hasClass('is-open')) {
            $('.mobile').removeClass('is-open');
        } else {
            $('.mobile').addClass('is-open');
        }
    });  
    
});